/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.trace;

import com.ibm.hwmca.base.trace.ConsoleTraceBean;
import com.ibm.hwmca.base.trace.ConsoleTraceControlData;
import com.ibm.hwmca.base.trace.ConsoleTraceControlDataP;
import com.ibm.hwmca.base.trace.ConsoleTraceErrorIds;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class ConsoleTraceTasklet
extends PanelTasklet
implements ConsoleTraceErrorIds {
    private static final String TRACE_MASKT = "XTRCTKLT";
    private static final String TRACE_MASKF = "XTRCTKLF";
    private static final String TRACE_MASKD = "XTRCTKLD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-16, "ConsoleTraceTasklet");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.trace.res.ConsoleTraceRes";
    private static final String PANEL_NAME = "TracePanel";
    private ConsoleTraceBean bean;
    public ConsoleTraceControlDataP _ctcdpMyData;
    public ConsoleTraceControlDataP startData;

    public ConsoleTraceTasklet() {
        Trace.trace(TRACE_MASKT, "<> ConsoleTraceTasklet constructor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ConsoleTraceTasklet.service()");
        try {
            if (taskletRequest.isInitialRequest()) {
                this.bean = new ConsoleTraceBean();
                this.bean.setBeanName("ConsoleTraceBean");
                this._ctcdpMyData = this.getConsoleTrace();
                this.startData = this.getConsoleTrace();
                this.bean.setStartData(this.startData);
                this.bean.setData(this._ctcdpMyData);
                SimServer simServer = SimServer.getSimServer();
                byte[] type = simServer.readSim(5);
                if (type != null && type.length > 0) {
                    if (type[0] == 2 || type[0] == 4) {
                        this.bean.setHMCFlag(true);
                    } else {
                        this.bean.setHMCFlag(false);
                    }
                } else {
                    this.bean.setHMCFlag(true);
                }
                taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME, this.bean);
            } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                taskletResponse.terminate();
            } else {
                String action = (String)taskletRequest.getData("action");
                Trace.trace(TRACE_MASKF, "ConsoleTraceTasklet.service client requested action is: " + action);
                if (action.equals("Save")) {
                    Trace.trace(TRACE_MASKF, "ConsoleTraceTasklet.service need to save parms");
                    ConsoleTraceControlDataP currentData = (ConsoleTraceControlDataP)taskletRequest.getData("ConsoleTraceControlDataP");
                    this.setConsoleTrace(currentData);
                    taskletResponse.noAction();
                } else {
                    taskletResponse.terminate();
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during service: " + e);
            e.printStackTrace();
            if (e instanceof TaskletException) {
                throw (TaskletException)e;
            }
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ConsoleTraceTasklet.service()");
    }

    public ConsoleTraceControlDataP getConsoleTrace() {
        ConsoleTraceControlData ctcdObj = new ConsoleTraceControlData();
        ConsoleTraceControlDataP ctcdpObj = new ConsoleTraceControlDataP();
        ctcdpObj._lMaxFileSize = ctcdObj._lMaxFileSize;
        ctcdpObj._bTraceToFile = ctcdObj._bTraceToFile;
        ctcdpObj._bMemoryTraceEnabled = ctcdObj._bMemoryTraceEnabled;
        int iSz = ctcdpObj._ctcdtTemplate.length;
        for (int i = 0; i < iSz; ++i) {
            ctcdpObj._ctcdtTemplate[i] = ctcdObj._ctcdtTemplate[i];
        }
        return ctcdpObj;
    }

    public void setConsoleTrace(ConsoleTraceControlDataP ctcdpObj) {
        ConsoleTraceControlData ctcdObj = new ConsoleTraceControlData();
        ctcdObj._lMaxFileSize = ctcdpObj._lMaxFileSize;
        ctcdObj._bTraceToFile = ctcdpObj._bTraceToFile;
        ctcdObj._bMemoryTraceEnabled = ctcdpObj._bMemoryTraceEnabled;
        int iSz = ctcdpObj._ctcdtTemplate.length;
        for (int i = 0; i < iSz; ++i) {
            ctcdObj._ctcdtTemplate[i] = ctcdpObj._ctcdtTemplate[i];
        }
        ctcdObj.setControlData();
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> ConsoleTraceTasklet.logException(" + throwable + ")");
        new FrameworkLog(logInfo, 1, throwable).log();
        Trace.trace(TRACE_MASKT, "<- ConsoleTraceTasklet.logException()");
    }
}

